import UserRecord = Leaderboard.UserRecord;
import UsersType = Leaderboard.UsersType;
import OrderingType = Leaderboard.OrderingType;

export enum ScoreResetIntervalOption {
    Day = 0,
    Week = 1,
    Month = 2,
    Year = 3
}

export enum LeaderboardEntryBgTextureType {
    MainSegment,
    MainSegmentBlue,
    BottomSegment,
    BottomSegmentBlue,
}

export enum BackgroundCustomization {
    None,
    Bitmoji,
    Texture,
}

export enum TimerTextureType {
    Red,
    Regular
}

export interface ILeaderboardVisual {
    visualiseEntries(otherRecords: Leaderboard.UserRecord[], currentUserRecord: Leaderboard.UserRecord): void
    setBitmoji(bitmojiTexture): void
    show(): void
    hide(): void
}

export interface LeaderboardBackground extends ScriptComponent {
    getEntriesParentScreenTransform(): ScreenTransform
    getTexturePreviewScreenTransform(): ScreenTransform
    getTopBorderScreenTransform(): ScreenTransform
    getTexturePreviewParentScreenTransform(): ScreenTransform
    getRoundedCornersTransform(): Transform
    getTouchZoneInteraction(): InteractionComponent
    getTouchZoneSceneObject(): SceneObject
    setHeaderAnchors(anchors: Rect): void
    setHeaderMaskTopAnchors(anchors: Rect): void
    getClosingZoneScreenTransform(): ScreenTransform
    setCurrentUserRecord(userRecord: Leaderboard.UserRecord): void
    setHeaderEnabled(enabled: boolean): void
    setFixedSizedTextureHeader(bitmoji: Texture): void
    setPostEffectsEnabled(enabled: boolean): void
    setLeaderboardName(name: string): void
    getOutOfLeaderboardTouchZone(): ScreenTransform
    setResisableTextureHeader(texture: Texture): void
    setBackgroundCustomizationOptionEnabled(backgroundCustomizationOption: BackgroundCustomization): void
    getCustomTextureImage(): Image
    setTimeLeftText(text: string): void
    setResetText(text: string): void
    setTimerUiEnabled(enabled: boolean): void
    setTimerTexture(timerTextureType: TimerTextureType)
}

export interface ICameraBadgeControl extends ScriptComponent {
    getParentScreenTransform(): ScreenTransform
    setUserRecord(userRecord: Leaderboard.UserRecord): void;
    setBitmoji(bitmoji: Texture): void
}

export interface IFullLeaderboard extends ILeaderboardVisual {
    setLeaderboardName(name: string): void
    setFallbackEnabled(enabled: boolean): void
}

export interface ICameraBadgeLeaderboard extends ILeaderboardVisual {
}

export interface ILeaderboardEntry extends ScriptComponent {
    setEntryIndex(index: number): void;
    setUserRecord(userRecord: Leaderboard.UserRecord, isGlobalLeaderboard: boolean): void;
    setBitmoji(bitmoji: Texture | null): void
    setEntryBgTextureType(leaderboardEntryBgTextureType: LeaderboardEntryBgTextureType): void
}

export interface ILeaderboardEntryFallback extends ScriptComponent {
    setEntryIndex(index: number): void;
}

export interface IDependencies extends ScriptComponent {
    getSideSwitcher(): SideSwitcher
}

export type EntryWrapper = {
    leaderboardEntry: ILeaderboardEntry
    screenTransform: ScreenTransform
    sceneObject: SceneObject
    representingIndex: number
    isCurrentUser: boolean,
    bitmojiRequestId: number | null
}

export type LeaderboardRecordsWrapper = {
    userRecords: UserRecord[]
    currentUserRecord: UserRecord | null
}

export type StickerDataEntry = {
    snapchatUser: SnapchatUser,
    stickerMap: Map<string, Promise<Texture>>
}

export type LeaderboardDetails = {
    currentDate: Date | null;
    offsetDateMillis: number | null;
    leaderboardRelativeIndex: number | null;
    leaderboardId: string | null;
    timeToFinish: number | null;
    leaderboardStartDate: string;
};

export type LeaderboardInitializationOptions = {
    name: string
    userType: UsersType
    scoreOrdering: OrderingType
    scoreResetInterval: ScoreResetIntervalOption
    userLimit: number,
    useTimer: boolean,
    leaderboardStartDate?: string //format "mm/dd/yyyy"
}

export type LeaderboardParams = {
    leaderboardName: string
    ttlSeconds: number
    scoreLifetimeOption: ScoreResetIntervalOption
    orderingType: OrderingType
    userType: UsersType
    userLimit: number
    leaderboardDetails: LeaderboardDetails | null,
    leaderboardNamePrefix: string,
    token?: number
}
